/*
 * Decompiled with CFR 0.152.
 */
package oledcomm.android.fft;

import oledcomm.android.fft.FourierTransform;

public class FFT
extends FourierTransform {
    public static final int ACCURACY_LOW = 512;
    public static final int ACCURACY_MIDEUM = 1024;
    public static final int ACCURACY_HIGH = 2048;
    private int[] k;
    private float[] l;
    private float[] m;

    public FFT(int n, float f) {
        super(n, f);
        if ((n & n - 1) != 0) {
            throw new IllegalArgumentException("FFT: timeSize must be a power of two.");
        }
        this.d();
        this.f();
    }

    @Override
    protected void a() {
        this.f = new float[this.a / 2 + 1];
        this.d = new float[this.a];
        this.e = new float[this.a];
    }

    @Override
    public void scaleBand(int n, float f) {
        if (f < 0.0f) {
            return;
        }
        int n2 = n;
        this.d[n2] = this.d[n2] * f;
        int n3 = n;
        this.e[n3] = this.e[n3] * f;
        int n4 = n;
        this.f[n4] = this.f[n4] * f;
        if (n != 0 && n != this.a / 2) {
            this.d[this.a - n] = this.d[n];
            this.e[this.a - n] = -this.e[n];
        }
    }

    @Override
    public void setBand(int n, float f) {
        if (f < 0.0f) {
            return;
        }
        if (this.d[n] == 0.0f && this.e[n] == 0.0f) {
            this.d[n] = f;
            this.f[n] = f;
        } else {
            int n2 = n;
            this.d[n2] = this.d[n2] / this.f[n];
            int n3 = n;
            this.e[n3] = this.e[n3] / this.f[n];
            this.f[n] = f;
            int n4 = n;
            this.d[n4] = this.d[n4] * this.f[n];
            int n5 = n;
            this.e[n5] = this.e[n5] * this.f[n];
        }
        if (n != 0 && n != this.a / 2) {
            this.d[this.a - n] = this.d[n];
            this.e[this.a - n] = -this.e[n];
        }
    }

    private void c() {
        for (int i = 1; i < this.d.length; i *= 2) {
            float f = this.b(i);
            float f2 = this.a(i);
            float f3 = 1.0f;
            float f4 = 0.0f;
            for (int j = 0; j < i; ++j) {
                for (int k = j; k < this.d.length; k += 2 * i) {
                    int n = k + i;
                    float f5 = f3 * this.d[n] - f4 * this.e[n];
                    float f6 = f3 * this.e[n] + f4 * this.d[n];
                    this.d[n] = this.d[k] - f5;
                    this.e[n] = this.e[k] - f6;
                    int n2 = k;
                    this.d[n2] = this.d[n2] + f5;
                    int n3 = k;
                    this.e[n3] = this.e[n3] + f6;
                }
                float f7 = f3;
                f3 = f7 * f - f4 * f2;
                f4 = f7 * f2 + f4 * f;
            }
        }
    }

    @Override
    public void forward(float[] fArray) {
        if (fArray.length != this.a) {
            return;
        }
        this.a(fArray, 0);
        this.c();
        this.b();
    }

    @Override
    public void forward(float[] fArray, int n) {
        if (fArray.length - n < this.a) {
            return;
        }
        this.a(fArray, n);
        this.c();
        this.b();
    }

    public void forward(float[] fArray, float[] fArray2) {
        if (fArray.length != this.a || fArray2.length != this.a) {
            return;
        }
        this.a(fArray, fArray2);
        this.e();
        this.c();
        this.b();
    }

    @Override
    public void inverse(float[] fArray) {
        if (fArray.length > this.d.length) {
            return;
        }
        int n = 0;
        while (n < this.a) {
            int n2 = n++;
            this.e[n2] = this.e[n2] * -1.0f;
        }
        this.e();
        this.c();
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = this.d[n] / (float)this.d.length;
        }
    }

    private void d() {
        int n = this.a;
        this.k = new int[n];
        this.k[0] = 0;
        int n2 = 1;
        int n3 = n / 2;
        while (n2 < n) {
            for (int i = 0; i < n2; ++i) {
                this.k[i + n2] = this.k[i] + n3;
            }
            n2 <<= 1;
            n3 >>= 1;
        }
    }

    private void a(float[] fArray, int n) {
        for (int i = 0; i < this.a; ++i) {
            this.d[i] = fArray[n + this.k[i]];
            this.e[i] = 0.0f;
        }
    }

    private void e() {
        float[] fArray = new float[this.d.length];
        float[] fArray2 = new float[this.e.length];
        for (int i = 0; i < this.d.length; ++i) {
            fArray[i] = this.d[this.k[i]];
            fArray2[i] = this.e[this.k[i]];
        }
        this.d = fArray;
        this.e = fArray2;
    }

    private float a(int n) {
        return this.l[n];
    }

    private float b(int n) {
        return this.m[n];
    }

    private void f() {
        int n = this.a;
        this.l = new float[n];
        this.m = new float[n];
        for (int i = 0; i < n; ++i) {
            this.l[i] = (float)Math.sin((float)(-Math.PI) / (float)i);
            this.m[i] = (float)Math.cos((float)(-Math.PI) / (float)i);
        }
    }
}

